# Overriding Javascripts

By default, Refinery will provide you with the required javascript files you need. Sometimes, these defaults do not suffice, and you will need to customize the Javascript files used by Refinery. This guide will show you how to:

* Change the default javascript libraries included;
* Add your own files to be included.

## Overriding the default Javascript libraries

Refinery version 2.0 and later use Rails's asset pipeline to deliver Javascript. This means that you can simply remove the two relevant lines from `application.js` to remove the default library, jQuery:

```erb
//= require jquery
//= require jquery_ujs
```

You can include your own files this way too; indeed, since `application.js` is minified in production, we recommend this as opposed to adding separate files.

## Adding additional files

If you absolutely must include your own discrete Javascript files, you can utilize the `content_for :javascripts` block, which will append Javascript files after `application.js`. This is often times useful when you are writing an extension that requires additional functionality, where you do not want to rely on a user to inject your dependency into his `application.js` file.

It should be used inside a view like so:

```erb
<% content_for :javascripts do %>
 <%= javascript_include_tag 'jquery-cycle.min' %>
<% end %>
```

This will append `jquery-cycle.min.js` after your `application.js` file.

__WARNING__: Previous versions of Refinery allowed you to define `content_for` blocks named `:before_javascript_libraries`, `:after_javascript_libraries`, and `:javascript_libraries`. These are no longer available, since the asset pipeline obviates their use.